/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.cloud.huiyansdkface.okhttp3;

import com.tencent.cloud.huiyansdkface.okhttp3.CipherSuite;
import com.tencent.cloud.huiyansdkface.okhttp3.Handshake;
import com.tencent.cloud.huiyansdkface.okhttp3.Headers;
import com.tencent.cloud.huiyansdkface.okhttp3.HttpUrl;
import com.tencent.cloud.huiyansdkface.okhttp3.MediaType;
import com.tencent.cloud.huiyansdkface.okhttp3.Protocol;
import com.tencent.cloud.huiyansdkface.okhttp3.Request;
import com.tencent.cloud.huiyansdkface.okhttp3.Response;
import com.tencent.cloud.huiyansdkface.okhttp3.ResponseBody;
import com.tencent.cloud.huiyansdkface.okhttp3.TlsVersion;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.Util;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.cache.CacheRequest;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.cache.CacheStrategy;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.cache.DiskLruCache;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.cache.InternalCache;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpHeaders;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.HttpMethod;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.http.StatusLine;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.io.FileSystem;
import com.tencent.cloud.huiyansdkface.okhttp3.internal.platform.Platform;
import com.tencent.cloud.huiyansdkface.okio.Buffer;
import com.tencent.cloud.huiyansdkface.okio.BufferedSink;
import com.tencent.cloud.huiyansdkface.okio.BufferedSource;
import com.tencent.cloud.huiyansdkface.okio.ByteString;
import com.tencent.cloud.huiyansdkface.okio.ForwardingSink;
import com.tencent.cloud.huiyansdkface.okio.ForwardingSource;
import com.tencent.cloud.huiyansdkface.okio.Okio;
import com.tencent.cloud.huiyansdkface.okio.Sink;
import com.tencent.cloud.huiyansdkface.okio.Source;
import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class Cache
implements Closeable,
Flushable {
    final InternalCache a = new InternalCache(this){
        private /* synthetic */ Cache a;
        {
            this.a = cache;
        }

        @Override
        public Response get(Request request) throws IOException {
            return this.a.a(request);
        }

        @Override
        public CacheRequest put(Response response) throws IOException {
            return this.a.a(response);
        }

        @Override
        public void remove(Request request) throws IOException {
            this.a.b(request);
        }

        @Override
        public void update(Response response, Response response2) {
            this.a.a(response, response2);
        }

        @Override
        public void trackConditionalCacheHit() {
            this.a.a();
        }

        @Override
        public void trackResponse(CacheStrategy cacheStrategy) {
            this.a.a(cacheStrategy);
        }
    };
    final DiskLruCache b;
    int c;
    int d;
    private int e;
    private int f;
    private int g;

    public Cache(File file, long l2) {
        this(file, l2, FileSystem.a);
    }

    private Cache(File file, long l2, FileSystem fileSystem) {
        this.b = DiskLruCache.create(fileSystem, file, 201105, 2, l2);
    }

    public static String key(HttpUrl httpUrl) {
        return ByteString.encodeUtf8(httpUrl.toString()).md5().hex();
    }

    final Response a(Request request) {
        Entry entry;
        Object object = Cache.key(request.url());
        try {
            object = this.b.get((String)object);
            if (object == null) {
                return null;
            }
        }
        catch (IOException iOException) {
            return null;
        }
        try {
            entry = new Entry(((DiskLruCache.Snapshot)object).getSource(0));
        }
        catch (IOException iOException) {
            Util.closeQuietly((Closeable)object);
            return null;
        }
        object = entry.response((DiskLruCache.Snapshot)object);
        if (!entry.matches(request, (Response)object)) {
            Util.closeQuietly(((Response)object).body());
            return null;
        }
        return object;
    }

    final CacheRequest a(Response response) {
        Object object = response.request().method();
        if (HttpMethod.invalidatesCache(response.request().method())) {
            try {
                this.b(response.request());
            }
            catch (IOException iOException) {}
            return null;
        }
        if (!((String)object).equals("GET")) {
            return null;
        }
        if (HttpHeaders.hasVaryAll(response)) {
            return null;
        }
        object = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            editor = this.b.edit(Cache.key(response.request().url()));
            if (editor == null) {
                return null;
            }
            ((Entry)object).writeTo(editor);
            return new CacheRequestImpl(editor);
        }
        catch (IOException iOException) {
            Cache.a(editor);
            return null;
        }
    }

    final void b(Request request) throws IOException {
        this.b.remove(Cache.key(request.url()));
    }

    final void a(Response closeable, Response object) {
        object = new Entry((Response)object);
        closeable = ((CacheResponseBody)((Response)closeable).body()).a;
        DiskLruCache.Editor editor = null;
        try {
            editor = ((DiskLruCache.Snapshot)closeable).edit();
            if (editor != null) {
                ((Entry)object).writeTo(editor);
                editor.commit();
            }
            return;
        }
        catch (IOException iOException) {
            Cache.a(editor);
            return;
        }
    }

    private static void a(DiskLruCache.Editor editor) {
        try {
            if (editor != null) {
                editor.abort();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final void initialize() throws IOException {
        this.b.initialize();
    }

    public final void delete() throws IOException {
        this.b.delete();
    }

    public final void evictAll() throws IOException {
        this.b.evictAll();
    }

    public final Iterator<String> urls() throws IOException {
        return new Iterator<String>(this){
            private Iterator<DiskLruCache.Snapshot> a;
            private String b;
            private boolean c;
            private /* synthetic */ Cache d;
            {
                this.d = cache;
                this.a = this.d.b.snapshots();
            }

            @Override
            public boolean hasNext() {
                if (this.b != null) {
                    return true;
                }
                this.c = false;
                while (this.a.hasNext()) {
                    try (DiskLruCache.Snapshot snapshot = this.a.next();){
                        BufferedSource bufferedSource = Okio.buffer(snapshot.getSource(0));
                        this.b = bufferedSource.readUtf8LineStrict();
                        return true;
                    }
                }
                return false;
            }

            @Override
            public String next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string = this.b;
                this.b = null;
                this.c = true;
                return string;
            }

            @Override
            public void remove() {
                if (!this.c) {
                    throw new IllegalStateException("remove() before next()");
                }
                this.a.remove();
            }
        };
    }

    public final synchronized int writeAbortCount() {
        return this.d;
    }

    public final synchronized int writeSuccessCount() {
        return this.c;
    }

    public final long size() throws IOException {
        return this.b.size();
    }

    public final long maxSize() {
        return this.b.getMaxSize();
    }

    @Override
    public final void flush() throws IOException {
        this.b.flush();
    }

    @Override
    public final void close() throws IOException {
        this.b.close();
    }

    public final File directory() {
        return this.b.getDirectory();
    }

    public final boolean isClosed() {
        return this.b.isClosed();
    }

    final synchronized void a(CacheStrategy cacheStrategy) {
        ++this.g;
        if (cacheStrategy.a != null) {
            ++this.e;
            return;
        }
        if (cacheStrategy.b != null) {
            ++this.f;
        }
    }

    final synchronized void a() {
        ++this.f;
    }

    public final synchronized int networkCount() {
        return this.e;
    }

    public final synchronized int hitCount() {
        return this.f;
    }

    public final synchronized int requestCount() {
        return this.g;
    }

    static int a(BufferedSource object) throws IOException {
        try {
            long l2 = object.readDecimalLong();
            object = object.readUtf8LineStrict();
            if (l2 < 0L || l2 > Integer.MAX_VALUE || !((String)object).isEmpty()) {
                throw new IOException("expected an int but was \"" + l2 + (String)object + "\"");
            }
            return (int)l2;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.getMessage());
        }
    }

    static class CacheResponseBody
    extends ResponseBody {
        final DiskLruCache.Snapshot a;
        private final BufferedSource b;
        private final String c;
        private final String d;

        CacheResponseBody(DiskLruCache.Snapshot snapshot, String object, String string) {
            this.a = snapshot;
            this.c = object;
            this.d = string;
            object = snapshot.getSource(1);
            this.b = Okio.buffer(new ForwardingSource(this, (Source)object, snapshot){
                private /* synthetic */ DiskLruCache.Snapshot a;
                {
                    this.a = snapshot;
                    super(source);
                }

                @Override
                public void close() throws IOException {
                    this.a.close();
                    super.close();
                }
            });
        }

        @Override
        public MediaType contentType() {
            if (this.c != null) {
                return MediaType.parse(this.c);
            }
            return null;
        }

        @Override
        public long contentLength() {
            try {
                if (this.d != null) {
                    return Long.parseLong(this.d);
                }
                return -1L;
            }
            catch (NumberFormatException numberFormatException) {
                return -1L;
            }
        }

        @Override
        public BufferedSource source() {
            return this.b;
        }
    }

    static final class Entry {
        private static final String a = Platform.get().getPrefix() + "-Sent-Millis";
        private static final String b = Platform.get().getPrefix() + "-Received-Millis";
        private final String c;
        private final Headers d;
        private final String e;
        private final Protocol f;
        private final int g;
        private final String h;
        private final Headers i;
        private final Handshake j;
        private final long k;
        private final long l;

        Entry(Source source) throws IOException {
            try {
                Object object = Okio.buffer(source);
                this.c = object.readUtf8LineStrict();
                this.e = object.readUtf8LineStrict();
                Object object2 = new Headers.Builder();
                int n2 = Cache.a(object);
                for (int i2 = 0; i2 < n2; ++i2) {
                    ((Headers.Builder)object2).a(object.readUtf8LineStrict());
                }
                this.d = ((Headers.Builder)object2).build();
                StatusLine statusLine = StatusLine.parse(object.readUtf8LineStrict());
                this.f = statusLine.a;
                this.g = statusLine.b;
                this.h = statusLine.c;
                object2 = new Headers.Builder();
                n2 = Cache.a(object);
                for (int i3 = 0; i3 < n2; ++i3) {
                    ((Headers.Builder)object2).a(object.readUtf8LineStrict());
                }
                Object object3 = ((Headers.Builder)object2).get(a);
                Object object4 = ((Headers.Builder)object2).get(b);
                ((Headers.Builder)object2).removeAll(a);
                ((Headers.Builder)object2).removeAll(b);
                this.k = object3 != null ? Long.parseLong((String)object3) : 0L;
                this.l = object4 != null ? Long.parseLong((String)object4) : 0L;
                this.i = ((Headers.Builder)object2).build();
                if (this.a()) {
                    object2 = object.readUtf8LineStrict();
                    if (((String)object2).length() > 0) {
                        throw new IOException("expected \"\" but was \"" + (String)object2 + "\"");
                    }
                    object2 = object.readUtf8LineStrict();
                    object2 = CipherSuite.forJavaName((String)object2);
                    object4 = Entry.a(object);
                    object3 = Entry.a(object);
                    object = !object.exhausted() ? TlsVersion.forJavaName(object.readUtf8LineStrict()) : TlsVersion.e;
                    this.j = Handshake.get((TlsVersion)((Object)object), (CipherSuite)object2, (List<Certificate>)object4, (List<Certificate>)object3);
                } else {
                    this.j = null;
                }
                return;
            }
            finally {
                source.close();
            }
        }

        Entry(Response response) {
            this.c = response.request().url().toString();
            this.d = HttpHeaders.varyHeaders(response);
            this.e = response.request().method();
            this.f = response.protocol();
            this.g = response.code();
            this.h = response.message();
            this.i = response.headers();
            this.j = response.handshake();
            this.k = response.sentRequestAtMillis();
            this.l = response.receivedResponseAtMillis();
        }

        public final void writeTo(DiskLruCache.Editor object) throws IOException {
            int n2;
            object = Okio.buffer(((DiskLruCache.Editor)object).newSink(0));
            object.writeUtf8(this.c).writeByte(10);
            object.writeUtf8(this.e).writeByte(10);
            object.writeDecimalLong(this.d.size()).writeByte(10);
            int n3 = this.d.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object.writeUtf8(this.d.name(n2)).writeUtf8(": ").writeUtf8(this.d.value(n2)).writeByte(10);
            }
            object.writeUtf8(new StatusLine(this.f, this.g, this.h).toString()).writeByte(10);
            object.writeDecimalLong(this.i.size() + 2).writeByte(10);
            n3 = this.i.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object.writeUtf8(this.i.name(n2)).writeUtf8(": ").writeUtf8(this.i.value(n2)).writeByte(10);
            }
            object.writeUtf8(a).writeUtf8(": ").writeDecimalLong(this.k).writeByte(10);
            object.writeUtf8(b).writeUtf8(": ").writeDecimalLong(this.l).writeByte(10);
            if (this.a()) {
                object.writeByte(10);
                object.writeUtf8(this.j.cipherSuite().javaName()).writeByte(10);
                Entry.a((BufferedSink)object, this.j.peerCertificates());
                Entry.a((BufferedSink)object, this.j.localCertificates());
                object.writeUtf8(this.j.tlsVersion().javaName()).writeByte(10);
            }
            object.close();
        }

        private boolean a() {
            return this.c.startsWith("https://");
        }

        private static List<Certificate> a(BufferedSource bufferedSource) throws IOException {
            int n2 = Cache.a(bufferedSource);
            if (n2 == -1) {
                return Collections.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> arrayList = new ArrayList<Certificate>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = bufferedSource.readUtf8LineStrict();
                    Buffer buffer = new Buffer();
                    buffer.write(ByteString.decodeBase64(string));
                    arrayList.add(certificateFactory.generateCertificate(buffer.inputStream()));
                }
                return arrayList;
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
        }

        private static void a(BufferedSink bufferedSink, List<Certificate> list) throws IOException {
            try {
                bufferedSink.writeDecimalLong(list.size()).writeByte(10);
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object = list.get(i2).getEncoded();
                    object = ByteString.of(object).base64();
                    bufferedSink.writeUtf8((String)object).writeByte(10);
                }
                return;
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new IOException(certificateEncodingException.getMessage());
            }
        }

        public final boolean matches(Request request, Response response) {
            return this.c.equals(request.url().toString()) && this.e.equals(request.method()) && HttpHeaders.varyMatches(response, this.d, request);
        }

        public final Response response(DiskLruCache.Snapshot snapshot) {
            String string = this.i.get("Content-Type");
            String string2 = this.i.get("Content-Length");
            Request request = new Request.Builder().url(this.c).method(this.e, null).headers(this.d).build();
            return new Response.Builder().request(request).protocol(this.f).code(this.g).message(this.h).headers(this.i).body(new CacheResponseBody(snapshot, string, string2)).handshake(this.j).sentRequestAtMillis(this.k).receivedResponseAtMillis(this.l).build();
        }
    }

    final class CacheRequestImpl
    implements CacheRequest {
        private final DiskLruCache.Editor c;
        private Sink d;
        private Sink e;
        boolean a;

        CacheRequestImpl(DiskLruCache.Editor editor) {
            this.c = editor;
            this.d = editor.newSink(1);
            this.e = new ForwardingSink(this, this.d, Cache.this, editor){
                private /* synthetic */ DiskLruCache.Editor a;
                private /* synthetic */ CacheRequestImpl b;
                {
                    this.b = cacheRequestImpl;
                    this.a = editor;
                    super(sink);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    Cache cache = this.b.Cache.this;
                    synchronized (cache) {
                        if (this.b.a) {
                            return;
                        }
                        this.b.a = true;
                        ++this.b.Cache.this.c;
                    }
                    super.close();
                    this.a.commit();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void abort() {
            Cache cache = Cache.this;
            synchronized (cache) {
                if (this.a) {
                    return;
                }
                this.a = true;
                ++Cache.this.d;
            }
            Util.closeQuietly(this.d);
            try {
                this.c.abort();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        @Override
        public final Sink body() {
            return this.e;
        }
    }
}

