/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.idasc.crashreport;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.tencent.bugly.idasc.BuglyStrategy;
import com.tencent.bugly.idasc.CrashModule;
import com.tencent.bugly.idasc.b;
import com.tencent.bugly.idasc.crashreport.common.info.a;
import com.tencent.bugly.idasc.crashreport.common.strategy.StrategyBean;
import com.tencent.bugly.idasc.crashreport.crash.BuglyBroadcastReceiver;
import com.tencent.bugly.idasc.crashreport.crash.c;
import com.tencent.bugly.idasc.crashreport.crash.d;
import com.tencent.bugly.idasc.crashreport.crash.h5.H5JavaScriptInterface;
import com.tencent.bugly.idasc.crashreport.crash.jni.NativeCrashHandler;
import com.tencent.bugly.idasc.proguard.q;
import com.tencent.bugly.idasc.proguard.w;
import com.tencent.bugly.idasc.proguard.x;
import com.tencent.bugly.idasc.proguard.z;
import java.net.InetAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CrashReport {
    private static Context a;

    public static void enableBugly(boolean bl) {
        b.a = bl;
    }

    public static void initCrashReport(Context context) {
        if (context == null) {
            return;
        }
        a = context;
        b.a(CrashModule.getInstance());
        b.a(context);
    }

    public static void initCrashReport(Context context, UserStrategy userStrategy) {
        if (context == null) {
            return;
        }
        a = context;
        b.a(CrashModule.getInstance());
        b.a(context, userStrategy);
    }

    public static void initCrashReport(Context context, String string, boolean bl) {
        if (context != null) {
            a = context;
            b.a(CrashModule.getInstance());
            b.a(context, string, bl, null);
        }
    }

    public static void initCrashReport(Context context, String string, boolean bl, UserStrategy userStrategy) {
        if (context == null) {
            return;
        }
        a = context;
        b.a(CrashModule.getInstance());
        b.a(context, string, bl, userStrategy);
    }

    public static String getBuglyVersion(Context context) {
        if (context == null) {
            x.d("Please call with context.", new Object[0]);
            return "unknown";
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a(context).c();
    }

    public static void testJavaCrash() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not test Java crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        a a2 = com.tencent.bugly.idasc.crashreport.common.info.a.b();
        if (a2 != null) {
            a2.b(24096);
        }
        throw new RuntimeException("This Crash create for Test! You can go to Bugly see more detail!");
    }

    public static void testNativeCrash() {
        CrashReport.testNativeCrash(false, false, false);
    }

    public static void testNativeCrash(boolean bl, boolean bl2, boolean bl3) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not test native crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        x.a("start to create a native crash for test!", new Object[0]);
        c.a().a(bl, bl2, bl3);
    }

    public static void testANRCrash() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not test ANR crash because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        x.a("start to create a anr crash for test!", new Object[0]);
        c.a().l();
    }

    public static void postException(Thread thread, int n2, String string, String string2, String string3, Map<String, String> map) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not post crash caught because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        d.a(thread, n2, string, string2, string3, map);
    }

    public static void postException(int n2, String string, String string2, String string3, Map<String, String> map) {
        CrashReport.postException(Thread.currentThread(), n2, string, string2, string3, map);
    }

    public static void postCatchedException(Throwable object) {
        Throwable throwable = object;
        object = Thread.currentThread();
        CrashReport.postCatchedException(throwable, (Thread)object, false);
    }

    public static void postCatchedException(Throwable throwable, Thread thread) {
        CrashReport.postCatchedException(throwable, thread, false);
    }

    public static void postCatchedException(Throwable throwable, Thread thread, boolean bl) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not post crash caught because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        if (throwable == null) {
            x.d("throwable is null, just return", new Object[0]);
            return;
        }
        if (thread == null) {
            thread = Thread.currentThread();
        }
        c.a().a(thread, throwable, false, null, null, bl);
    }

    public static void closeNativeReport() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not close native report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        c.a().g();
    }

    public static void startCrashReport() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not start crash report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        c.a().c();
    }

    public static void closeCrashReport() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not close crash report because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        c.a().d();
    }

    public static void closeBugly() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not close bugly because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.w((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        if (a == null) {
            return;
        }
        Object object = BuglyBroadcastReceiver.getInstance();
        if (object != null) {
            object.unregister(a);
        }
        CrashReport.closeCrashReport();
        com.tencent.bugly.idasc.crashreport.biz.b.a(a);
        object = w.a();
        if (object != null) {
            ((w)object).b();
        }
    }

    public static void setUserSceneTag(Context context, int n2) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set tag caught because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.e((String)x.a, (String)"setTag args context should not be null");
            return;
        }
        if (n2 <= 0) {
            x.d("setTag args tagId should > 0", new Object[0]);
        }
        com.tencent.bugly.idasc.crashreport.common.info.a.a(context).a(n2);
        x.b("[param] set user scene tag: %d", n2);
    }

    public static int getUserSceneTagId(Context context) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not get user scene tag because bugly is disable.");
            return -1;
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getUserSceneTagId args context should not be null");
            return -1;
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a(context).A();
    }

    public static String getUserData(Context context, String string) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not get user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getUserDataValue args context should not be null");
            return "unknown";
        }
        if (z.a(string)) {
            return null;
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a(context).h(string);
    }

    public static void putUserData(Context context, String string, String string2) {
        Object object;
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not put user data because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)x.a, (String)"putUserData args context should not be null");
            return;
        }
        if (string == null) {
            x.d("putUserData args key should not be null or empty", new Object[0]);
            return;
        }
        if (string2 == null) {
            x.d("putUserData args value should not be null", new Object[0]);
            return;
        }
        if (string2.length() > 200) {
            x.d("user data value length over limit %d, it will be cutted!", 200);
            string2 = string2.substring(0, 200);
        }
        if (((a)(object = com.tencent.bugly.idasc.crashreport.common.info.a.a(context))).x().contains(string)) {
            object = NativeCrashHandler.getInstance();
            if (object != null) {
                ((NativeCrashHandler)object).putKeyValueToNative(string, string2);
            }
            com.tencent.bugly.idasc.crashreport.common.info.a.a(context).b(string, string2);
            x.c("replace KV %s %s", string, string2);
            return;
        }
        if (((a)object).w() >= 50) {
            x.d("user data size is over limit %d, it will be cutted!", 50);
            return;
        }
        if (string.length() > 50) {
            x.d("user data key length over limit %d , will drop this new key %s", 50, string);
            string = string.substring(0, 50);
        }
        if ((object = NativeCrashHandler.getInstance()) != null) {
            ((NativeCrashHandler)object).putKeyValueToNative(string, string2);
        }
        com.tencent.bugly.idasc.crashreport.common.info.a.a(context).b(string, string2);
        x.b("[param] set user data: %s - %s", string, string2);
    }

    public static String removeUserData(Context context, String string) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not remove user data because bugly is disable.");
            return "unknown";
        }
        if (context == null) {
            Log.e((String)x.a, (String)"removeUserData args context should not be null");
            return "unknown";
        }
        if (z.a(string)) {
            return null;
        }
        x.b("[param] remove user data: %s", string);
        return com.tencent.bugly.idasc.crashreport.common.info.a.a(context).g(string);
    }

    public static Set<String> getAllUserDataKeys(Context context) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not get all keys of user data because bugly is disable.");
            return new HashSet<String>();
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getAllUserDataKeys args context should not be null");
            return new HashSet<String>();
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a(context).x();
    }

    public static int getUserDatasSize(Context context) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not get size of user data because bugly is disable.");
            return -1;
        }
        if (context == null) {
            Log.e((String)x.a, (String)"getUserDatasSize args context should not be null");
            return -1;
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a(context).w();
    }

    public static String getAppID() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not get App ID because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a(a).f();
    }

    public static void setUserId(String string) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set user ID because bugly is disable.");
            return;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return;
        }
        CrashReport.setUserId(a, string);
    }

    public static void setUserId(Context context, String object) {
        Object object2;
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set user ID because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.e((String)x.a, (String)"Context should not be null when bugly has not been initialed!");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)object)) {
            x.d("userId should not be null", new Object[0]);
            return;
        }
        if (((String)object).length() > 100) {
            object2 = ((String)object).substring(0, 100);
            x.d("userId %s length is over limit %d substring to %s", object, 100, object2);
            object = object2;
        }
        if (((String)object).equals(com.tencent.bugly.idasc.crashreport.common.info.a.a(context).g())) {
            return;
        }
        com.tencent.bugly.idasc.crashreport.common.info.a.a(context).b((String)object);
        x.b("[user] set userId : %s", object);
        object2 = NativeCrashHandler.getInstance();
        if (object2 != null) {
            ((NativeCrashHandler)object2).setNativeUserId((String)object);
        }
        if (CrashModule.getInstance().hasInitialized()) {
            com.tencent.bugly.idasc.crashreport.biz.b.a();
        }
    }

    public static String getUserId() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not get user ID because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a(a).g();
    }

    public static void setDeviceId(Context context, String string) {
        if (string != null) {
            com.tencent.bugly.idasc.crashreport.common.info.a.a(context).c(string);
        }
    }

    public static void setDeviceModel(Context context, String string) {
        if (string != null) {
            com.tencent.bugly.idasc.crashreport.common.info.a.a(context).d(string);
        }
    }

    public static String getDeviceID(Context context) {
        return com.tencent.bugly.idasc.crashreport.common.info.a.a(context).h();
    }

    public static String getAppVer() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not get app version because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a((Context)CrashReport.a).j;
    }

    public static String getAppChannel() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not get App channel because bugly is disable.");
            return "unknown";
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return "unknown";
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a((Context)CrashReport.a).l;
    }

    public static void setContext(Context context) {
        a = context;
    }

    public static boolean isLastSessionCrash() {
        if (!b.a) {
            Log.w((String)x.a, (String)"The info 'isLastSessionCrash' is not accurate because bugly is disable.");
            return false;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return false;
        }
        return c.a().b();
    }

    public static void setSdkExtraData(Context context, String string, String string2) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not put SDK extra data because bugly is disable.");
            return;
        }
        if (context == null || z.a(string) || z.a(string2)) {
            return;
        }
        com.tencent.bugly.idasc.crashreport.common.info.a.a(context).a(string, string2);
    }

    public static Map<String, String> getSdkExtraData() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not get SDK extra data because bugly is disable.");
            return new HashMap<String, String>();
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            Log.e((String)x.a, (String)"CrashReport has not been initialed! pls to call method 'initCrashReport' first!");
            return null;
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a((Context)CrashReport.a).B;
    }

    public static Map<String, String> getSdkExtraData(Context context) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not get SDK extra data because bugly is disable.");
            return new HashMap<String, String>();
        }
        if (context == null) {
            x.d("Context should not be null.", new Object[0]);
            return null;
        }
        return com.tencent.bugly.idasc.crashreport.common.info.a.a((Context)context).B;
    }

    private static void putSdkData(Context context, String string, String string2) {
        if (context == null || z.a(string) || z.a(string2)) {
            return;
        }
        if ((string = string.replace("[a-zA-Z[0-9]]+", "")).length() > 100) {
            Log.w((String)x.a, (String)String.format("putSdkData key length over limit %d, will be cutted.", 50));
            string = string.substring(0, 50);
        }
        if (string2.length() > 500) {
            Log.w((String)x.a, (String)String.format("putSdkData value length over limit %d, will be cutted!", 200));
            string2 = string2.substring(0, 200);
        }
        com.tencent.bugly.idasc.crashreport.common.info.a.a(context).c(string, string2);
        x.b(String.format("[param] putSdkData data: %s - %s", string, string2), new Object[0]);
    }

    public static void setIsAppForeground(Context context, boolean bl) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set 'isAppForeground' because bugly is disable.");
            return;
        }
        if (context == null) {
            x.d("Context should not be null.", new Object[0]);
            return;
        }
        if (bl) {
            x.c("App is in foreground.", new Object[0]);
        } else {
            x.c("App is in background.", new Object[0]);
        }
        com.tencent.bugly.idasc.crashreport.common.info.a.a(context).a(bl);
    }

    public static void setIsDevelopmentDevice(Context context, boolean bl) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set 'isDevelopmentDevice' because bugly is disable.");
            return;
        }
        if (context == null) {
            x.d("Context should not be null.", new Object[0]);
            return;
        }
        if (bl) {
            x.c("This is a development device.", new Object[0]);
        } else {
            x.c("This is not a development device.", new Object[0]);
        }
        com.tencent.bugly.idasc.crashreport.common.info.a.a((Context)context).z = bl;
    }

    public static void setSessionIntervalMills(long l2) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set 'SessionIntervalMills' because bugly is disable.");
            return;
        }
        com.tencent.bugly.idasc.crashreport.biz.b.a(l2);
    }

    public static void setAppVersion(Context object, String string) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set App version because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)x.a, (String)"setAppVersion args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)x.a, (String)"App version is null, will not set");
            return;
        }
        com.tencent.bugly.idasc.crashreport.common.info.a.a((Context)object).j = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppVersion(string);
        }
    }

    public static void setAppChannel(Context object, String string) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set App channel because Bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)x.a, (String)"setAppChannel args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)x.a, (String)"App channel is null, will not set");
            return;
        }
        com.tencent.bugly.idasc.crashreport.common.info.a.a((Context)object).l = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppChannel(string);
        }
    }

    public static void setAppPackage(Context object, String string) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        if (object == null) {
            Log.w((String)x.a, (String)"setAppPackage args context should not be null");
            return;
        }
        if (string == null) {
            Log.w((String)x.a, (String)"App package is null, will not set");
            return;
        }
        com.tencent.bugly.idasc.crashreport.common.info.a.a((Context)object).c = string;
        object = NativeCrashHandler.getInstance();
        if (object != null) {
            ((NativeCrashHandler)object).setNativeAppPackage(string);
        }
    }

    public static void setCrashFilter(String string) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Set crash stack filter: " + string));
        c.n = string;
    }

    public static void setCrashRegularFilter(String string) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Set crash stack filter: " + string));
        c.o = string;
    }

    public static void setHandleNativeCrashInJava(boolean bl) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set App package because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Should handle native crash in Java profile after handled in native profile: " + bl));
        NativeCrashHandler.setShouldHandleInJava(bl);
    }

    public static void setBuglyDbName(String string) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set DB name because bugly is disable.");
            return;
        }
        Log.i((String)x.a, (String)("Set Bugly DB name: " + string));
        q.a = string;
    }

    public static void enableObtainId(Context context, boolean bl) {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set DB name because bugly is disable.");
            return;
        }
        if (context == null) {
            Log.w((String)x.a, (String)"enableObtainId args context should not be null");
            return;
        }
        Log.i((String)x.a, (String)("Enable identification obtaining? " + bl));
        com.tencent.bugly.idasc.crashreport.common.info.a.a(context).b(bl);
    }

    public static void setServerUrl(String string) {
        if (z.a(string) || !z.c(string)) {
            Log.i((String)x.a, (String)"URL is invalid.");
            return;
        }
        com.tencent.bugly.idasc.crashreport.common.strategy.a.a(string);
        StrategyBean.a = string;
        StrategyBean.b = string;
    }

    public static void uploadUserInfo() {
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not upload user info because bugly is disable.");
            return;
        }
        if (com.tencent.bugly.idasc.crashreport.biz.b.a == null) {
            Log.w((String)x.a, (String)"Can not upload user info because bugly is not init.");
            return;
        }
        com.tencent.bugly.idasc.crashreport.biz.b.a.b();
    }

    public static boolean setJavascriptMonitor(WebView webView, boolean bl) {
        return CrashReport.setJavascriptMonitor(webView, bl, false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static boolean setJavascriptMonitor(WebView webView, boolean bl, boolean bl2) {
        if (webView == null) {
            Log.w((String)x.a, (String)"WebView is null.");
            return false;
        }
        webView.getSettings().setSavePassword(false);
        webView.getSettings().setAllowFileAccess(false);
        return CrashReport.setJavascriptMonitor(new WebViewInterface(webView){
            private /* synthetic */ WebView a;
            {
                this.a = webView;
            }

            @Override
            public final String getUrl() {
                return this.a.getUrl();
            }

            @Override
            public final void setJavaScriptEnabled(boolean bl) {
                WebSettings webSettings = this.a.getSettings();
                if (!webSettings.getJavaScriptEnabled()) {
                    webSettings.setJavaScriptEnabled(true);
                }
            }

            @Override
            public final void loadUrl(String string) {
                this.a.loadUrl(string);
            }

            @Override
            public final void addJavascriptInterface(H5JavaScriptInterface h5JavaScriptInterface, String string) {
                this.a.addJavascriptInterface((Object)h5JavaScriptInterface, string);
            }

            @Override
            public final CharSequence getContentDescription() {
                return this.a.getContentDescription();
            }
        }, bl, bl2);
    }

    public static boolean setJavascriptMonitor(WebViewInterface webViewInterface, boolean bl) {
        return CrashReport.setJavascriptMonitor(webViewInterface, bl, false);
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public static boolean setJavascriptMonitor(WebViewInterface webViewInterface, boolean bl, boolean bl2) {
        if (webViewInterface == null) {
            Log.w((String)x.a, (String)"WebViewInterface is null.");
            return false;
        }
        if (!CrashModule.getInstance().hasInitialized()) {
            x.e("CrashReport has not been initialed! please to call method 'initCrashReport' first!", new Object[0]);
            return false;
        }
        x.a("Set Javascript exception monitor of webview.", new Object[0]);
        if (!b.a) {
            Log.w((String)x.a, (String)"Can not set JavaScript monitor because bugly is disable.");
            return false;
        }
        x.c("URL of webview is %s", webViewInterface.getUrl());
        if (!bl2 && Build.VERSION.SDK_INT < 19) {
            x.e("This interface is only available for Android 4.4 or later.", new Object[0]);
            return false;
        }
        x.a("Enable the javascript needed by webview monitor.", new Object[0]);
        webViewInterface.setJavaScriptEnabled(true);
        H5JavaScriptInterface h5JavaScriptInterface = H5JavaScriptInterface.getInstance(webViewInterface);
        if (h5JavaScriptInterface != null) {
            x.a("Add a secure javascript interface to the webview.", new Object[0]);
            webViewInterface.addJavascriptInterface(h5JavaScriptInterface, "exceptionUploader");
        }
        if (bl) {
            x.a("Inject bugly.js(v%s) to the webview.", com.tencent.bugly.idasc.crashreport.crash.h5.b.b());
            String string = com.tencent.bugly.idasc.crashreport.crash.h5.b.a();
            if (string == null) {
                x.e("Failed to inject Bugly.js.", com.tencent.bugly.idasc.crashreport.crash.h5.b.b());
                return false;
            }
            webViewInterface.loadUrl("javascript:" + string);
        }
        return true;
    }

    public static void setHttpProxy(String string, int n2) {
        com.tencent.bugly.idasc.proguard.a.a(string, n2);
    }

    public static void setHttpProxy(InetAddress inetAddress, int n2) {
        com.tencent.bugly.idasc.proguard.a.a(inetAddress, n2);
    }

    public static Proxy getHttpProxy() {
        return com.tencent.bugly.idasc.proguard.a.b();
    }

    public static interface WebViewInterface {
        public String getUrl();

        public void setJavaScriptEnabled(boolean var1);

        public void loadUrl(String var1);

        public void addJavascriptInterface(H5JavaScriptInterface var1, String var2);

        public CharSequence getContentDescription();
    }

    public static class CrashHandleCallback
    extends BuglyStrategy.a {
    }

    public static class UserStrategy
    extends BuglyStrategy {
        private CrashHandleCallback c;

        public UserStrategy(Context context) {
        }

        @Override
        public synchronized void setCallBackType(int n2) {
            this.a = n2;
        }

        @Override
        public synchronized int getCallBackType() {
            return this.a;
        }

        @Override
        public synchronized void setCloseErrorCallback(boolean bl) {
            this.b = bl;
        }

        @Override
        public synchronized boolean getCloseErrorCallback() {
            return this.b;
        }

        @Override
        public synchronized CrashHandleCallback getCrashHandleCallback() {
            return this.c;
        }

        public synchronized void setCrashHandleCallback(CrashHandleCallback crashHandleCallback) {
            this.c = crashHandleCallback;
        }
    }
}

