/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageLoader;
import com.android.volley.toolbox.Threads;

public class NetworkImageView
extends ImageView {
    private String mUrl;
    private int mDefaultImageId;
    @Nullable
    private Drawable mDefaultImageDrawable;
    @Nullable
    private Bitmap mDefaultImageBitmap;
    private int mErrorImageId;
    @Nullable
    private Drawable mErrorImageDrawable;
    @Nullable
    private Bitmap mErrorImageBitmap;
    private ImageLoader mImageLoader;
    private ImageLoader.ImageContainer mImageContainer;

    public NetworkImageView(Context context) {
        this(context, null);
    }

    public NetworkImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NetworkImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @MainThread
    public void setImageUrl(String url, ImageLoader imageLoader) {
        Threads.throwIfNotOnMainThread();
        this.mUrl = url;
        this.mImageLoader = imageLoader;
        this.loadImageIfNecessary(false);
    }

    public void setDefaultImageResId(int defaultImage) {
        this.mDefaultImageBitmap = null;
        this.mDefaultImageDrawable = null;
        this.mDefaultImageId = defaultImage;
    }

    public void setDefaultImageDrawable(@Nullable Drawable defaultImageDrawable) {
        this.mDefaultImageId = 0;
        this.mDefaultImageBitmap = null;
        this.mDefaultImageDrawable = defaultImageDrawable;
    }

    public void setDefaultImageBitmap(Bitmap defaultImage) {
        this.mDefaultImageId = 0;
        this.mDefaultImageDrawable = null;
        this.mDefaultImageBitmap = defaultImage;
    }

    public void setErrorImageResId(int errorImage) {
        this.mErrorImageBitmap = null;
        this.mErrorImageDrawable = null;
        this.mErrorImageId = errorImage;
    }

    public void setErrorImageDrawable(@Nullable Drawable errorImageDrawable) {
        this.mErrorImageId = 0;
        this.mErrorImageBitmap = null;
        this.mErrorImageDrawable = errorImageDrawable;
    }

    public void setErrorImageBitmap(Bitmap errorImage) {
        this.mErrorImageId = 0;
        this.mErrorImageDrawable = null;
        this.mErrorImageBitmap = errorImage;
    }

    void loadImageIfNecessary(final boolean isInLayoutPass) {
        boolean isFullyWrapContent;
        int width = this.getWidth();
        int height = this.getHeight();
        ImageView.ScaleType scaleType = this.getScaleType();
        boolean wrapWidth = false;
        boolean wrapHeight = false;
        if (this.getLayoutParams() != null) {
            wrapWidth = this.getLayoutParams().width == -2;
            wrapHeight = this.getLayoutParams().height == -2;
        }
        boolean bl = isFullyWrapContent = wrapWidth && wrapHeight;
        if (width == 0 && height == 0 && !isFullyWrapContent) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (this.mImageContainer != null) {
                this.mImageContainer.cancelRequest();
                this.mImageContainer = null;
            }
            this.setDefaultImageOrNull();
            return;
        }
        if (this.mImageContainer != null && this.mImageContainer.getRequestUrl() != null) {
            if (this.mImageContainer.getRequestUrl().equals(this.mUrl)) {
                return;
            }
            this.mImageContainer.cancelRequest();
            this.setDefaultImageOrNull();
        }
        int maxWidth = wrapWidth ? 0 : width;
        int maxHeight = wrapHeight ? 0 : height;
        this.mImageContainer = this.mImageLoader.get(this.mUrl, new ImageLoader.ImageListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                if (NetworkImageView.this.mErrorImageId != 0) {
                    NetworkImageView.this.setImageResource(NetworkImageView.this.mErrorImageId);
                } else if (NetworkImageView.this.mErrorImageDrawable != null) {
                    NetworkImageView.this.setImageDrawable(NetworkImageView.this.mErrorImageDrawable);
                } else if (NetworkImageView.this.mErrorImageBitmap != null) {
                    NetworkImageView.this.setImageBitmap(NetworkImageView.this.mErrorImageBitmap);
                }
            }

            @Override
            public void onResponse(final ImageLoader.ImageContainer response, boolean isImmediate) {
                if (isImmediate && isInLayoutPass) {
                    NetworkImageView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            this.onResponse(response, false);
                        }
                    });
                    return;
                }
                if (response.getBitmap() != null) {
                    NetworkImageView.this.setImageBitmap(response.getBitmap());
                } else if (NetworkImageView.this.mDefaultImageId != 0) {
                    NetworkImageView.this.setImageResource(NetworkImageView.this.mDefaultImageId);
                } else if (NetworkImageView.this.mDefaultImageDrawable != null) {
                    NetworkImageView.this.setImageDrawable(NetworkImageView.this.mDefaultImageDrawable);
                } else if (NetworkImageView.this.mDefaultImageBitmap != null) {
                    NetworkImageView.this.setImageBitmap(NetworkImageView.this.mDefaultImageBitmap);
                }
            }
        }, maxWidth, maxHeight, scaleType);
    }

    private void setDefaultImageOrNull() {
        if (this.mDefaultImageId != 0) {
            this.setImageResource(this.mDefaultImageId);
        } else if (this.mDefaultImageDrawable != null) {
            this.setImageDrawable(this.mDefaultImageDrawable);
        } else if (this.mDefaultImageBitmap != null) {
            this.setImageBitmap(this.mDefaultImageBitmap);
        } else {
            this.setImageBitmap(null);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.loadImageIfNecessary(true);
    }

    protected void onDetachedFromWindow() {
        if (this.mImageContainer != null) {
            this.mImageContainer.cancelRequest();
            this.setImageBitmap(null);
            this.mImageContainer = null;
        }
        super.onDetachedFromWindow();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }
}

