/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import androidx.annotation.Nullable;
import com.android.volley.Header;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NetworkResponse {
    public final int statusCode;
    public final byte[] data;
    @Nullable
    public final Map<String, String> headers;
    @Nullable
    public final List<Header> allHeaders;
    public final boolean notModified;
    public final long networkTimeMs;

    @Deprecated
    public NetworkResponse(int statusCode, byte[] data, @Nullable Map<String, String> headers, boolean notModified, long networkTimeMs) {
        this(statusCode, data, headers, NetworkResponse.toAllHeaderList(headers), notModified, networkTimeMs);
    }

    public NetworkResponse(int statusCode, byte[] data, boolean notModified, long networkTimeMs, @Nullable List<Header> allHeaders) {
        this(statusCode, data, NetworkResponse.toHeaderMap(allHeaders), allHeaders, notModified, networkTimeMs);
    }

    @Deprecated
    public NetworkResponse(int statusCode, byte[] data, @Nullable Map<String, String> headers, boolean notModified) {
        this(statusCode, data, headers, notModified, 0L);
    }

    public NetworkResponse(byte[] data) {
        this(200, data, false, 0L, Collections.emptyList());
    }

    @Deprecated
    public NetworkResponse(byte[] data, @Nullable Map<String, String> headers) {
        this(200, data, headers, false, 0L);
    }

    private NetworkResponse(int statusCode, byte[] data, @Nullable Map<String, String> headers, @Nullable List<Header> allHeaders, boolean notModified, long networkTimeMs) {
        this.statusCode = statusCode;
        this.data = data;
        this.headers = headers;
        this.allHeaders = allHeaders == null ? null : Collections.unmodifiableList(allHeaders);
        this.notModified = notModified;
        this.networkTimeMs = networkTimeMs;
    }

    @Nullable
    private static Map<String, String> toHeaderMap(@Nullable List<Header> allHeaders) {
        if (allHeaders == null) {
            return null;
        }
        if (allHeaders.isEmpty()) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : allHeaders) {
            headers.put(header.getName(), header.getValue());
        }
        return headers;
    }

    @Nullable
    private static List<Header> toAllHeaderList(@Nullable Map<String, String> headers) {
        if (headers == null) {
            return null;
        }
        if (headers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Header> allHeaders = new ArrayList<Header>(headers.size());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            allHeaders.add(new Header(header.getKey(), header.getValue()));
        }
        return allHeaders;
    }
}

