/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import androidx.annotation.Nullable;
import com.android.volley.Header;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface Cache {
    @Nullable
    public Entry get(String var1);

    public void put(String var1, Entry var2);

    public void initialize();

    public void invalidate(String var1, boolean var2);

    public void remove(String var1);

    public void clear();

    public static class Entry {
        public byte[] data;
        public String etag;
        public long serverDate;
        public long lastModified;
        public long ttl;
        public long softTtl;
        public Map<String, String> responseHeaders = Collections.emptyMap();
        public List<Header> allResponseHeaders;

        public boolean isExpired() {
            return this.isExpired(System.currentTimeMillis());
        }

        boolean isExpired(long currentTimeMillis) {
            return this.ttl < currentTimeMillis;
        }

        public boolean refreshNeeded() {
            return this.refreshNeeded(System.currentTimeMillis());
        }

        boolean refreshNeeded(long currentTimeMillis) {
            return this.softTtl < currentTimeMillis;
        }
    }
}

