/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley;

import androidx.annotation.RestrictTo;
import com.android.volley.Network;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.VolleyError;
import com.android.volley.VolleyLog;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AsyncNetwork
implements Network {
    private ExecutorService mBlockingExecutor;
    private ExecutorService mNonBlockingExecutor;
    private ScheduledExecutorService mNonBlockingScheduledExecutor;

    protected AsyncNetwork() {
    }

    public abstract void performRequest(Request<?> var1, OnRequestComplete var2);

    @Override
    public NetworkResponse performRequest(Request<?> request) throws VolleyError {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference response = new AtomicReference();
        final AtomicReference error = new AtomicReference();
        this.performRequest(request, new OnRequestComplete(){

            @Override
            public void onSuccess(NetworkResponse networkResponse) {
                response.set(networkResponse);
                latch.countDown();
            }

            @Override
            public void onError(VolleyError volleyError) {
                error.set(volleyError);
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            VolleyLog.e(e, "while waiting for CountDownLatch", new Object[0]);
            Thread.currentThread().interrupt();
            throw new VolleyError(e);
        }
        if (response.get() != null) {
            return (NetworkResponse)response.get();
        }
        if (error.get() != null) {
            throw (VolleyError)error.get();
        }
        throw new VolleyError("Neither response entry was set");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setNonBlockingExecutor(ExecutorService executor) {
        this.mNonBlockingExecutor = executor;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setBlockingExecutor(ExecutorService executor) {
        this.mBlockingExecutor = executor;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setNonBlockingScheduledExecutor(ScheduledExecutorService executor) {
        this.mNonBlockingScheduledExecutor = executor;
    }

    protected ExecutorService getBlockingExecutor() {
        return this.mBlockingExecutor;
    }

    protected ExecutorService getNonBlockingExecutor() {
        return this.mNonBlockingExecutor;
    }

    protected ScheduledExecutorService getNonBlockingScheduledExecutor() {
        return this.mNonBlockingScheduledExecutor;
    }

    public static interface OnRequestComplete {
        public void onSuccess(NetworkResponse var1);

        public void onError(VolleyError var1);
    }
}

