/*
 * Decompiled with CFR 0.152.
 */
package com.m4399.gamecenter.service.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.m4399.gamecenter.service.aidl.ISdkTaskCallback;

public interface ITaskBinder
extends IInterface {
    public static final String DESCRIPTOR = "com.m4399.gamecenter.service.aidl.ITaskBinder";

    public boolean isTaskRunning() throws RemoteException;

    public void stopRunningTask() throws RemoteException;

    public void registerCallback(ISdkTaskCallback var1) throws RemoteException;

    public void unregisterCallback(ISdkTaskCallback var1) throws RemoteException;

    public void getGameBoxUdId() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITaskBinder {
        static final int TRANSACTION_isTaskRunning = 1;
        static final int TRANSACTION_stopRunningTask = 2;
        static final int TRANSACTION_registerCallback = 3;
        static final int TRANSACTION_unregisterCallback = 4;
        static final int TRANSACTION_getGameBoxUdId = 5;

        public Stub() {
            Stub stub = this;
            stub.attachInterface(this, ITaskBinder.DESCRIPTOR);
        }

        public static ITaskBinder asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(ITaskBinder.DESCRIPTOR);
            if (iInterface != null && iInterface instanceof ITaskBinder) {
                return (ITaskBinder)iInterface;
            }
            return new Proxy(iBinder);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int n9, Parcel parcel, Parcel parcel2, int n10) throws RemoteException {
            String string = ITaskBinder.DESCRIPTOR;
            if (n9 >= 1 && n9 <= 0xFFFFFF) {
                parcel.enforceInterface(string);
            }
            if (n9 != 1598968902) {
                switch (n9) {
                    default: {
                        return super.onTransact(n9, parcel, parcel2, n10);
                    }
                    case 5: {
                        this.getGameBoxUdId();
                        parcel2.writeNoException();
                        break;
                    }
                    case 4: {
                        this.unregisterCallback(ISdkTaskCallback.Stub.asInterface(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        break;
                    }
                    case 3: {
                        this.registerCallback(ISdkTaskCallback.Stub.asInterface(parcel.readStrongBinder()));
                        parcel2.writeNoException();
                        break;
                    }
                    case 2: {
                        this.stopRunningTask();
                        parcel2.writeNoException();
                        break;
                    }
                    case 1: {
                        Parcel parcel3 = parcel2;
                        int n11 = this.isTaskRunning();
                        parcel3.writeNoException();
                        parcel3.writeInt(n11);
                    }
                }
                return true;
            }
            parcel2.writeString(string);
            return true;
        }

        private static class Proxy
        implements ITaskBinder {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITaskBinder.DESCRIPTOR;
            }

            @Override
            public boolean isTaskRunning() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(ITaskBinder.DESCRIPTOR);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.readException();
                boolean bl = parcel2.readInt() != 0;
                parcel2.recycle();
                parcel.recycle();
                return bl;
            }

            @Override
            public void stopRunningTask() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(ITaskBinder.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.readException();
                parcel2.recycle();
                parcel.recycle();
            }

            @Override
            public void registerCallback(ISdkTaskCallback iSdkTaskCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(ITaskBinder.DESCRIPTOR);
                    parcel.writeStrongInterface((IInterface)iSdkTaskCallback);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.readException();
                parcel2.recycle();
                parcel.recycle();
            }

            @Override
            public void unregisterCallback(ISdkTaskCallback iSdkTaskCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(ITaskBinder.DESCRIPTOR);
                    parcel.writeStrongInterface((IInterface)iSdkTaskCallback);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.readException();
                parcel2.recycle();
                parcel.recycle();
            }

            @Override
            public void getGameBoxUdId() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(ITaskBinder.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                parcel2.readException();
                parcel2.recycle();
                parcel.recycle();
            }
        }
    }

    public static class Default
    implements ITaskBinder {
        @Override
        public boolean isTaskRunning() throws RemoteException {
            return false;
        }

        @Override
        public void stopRunningTask() throws RemoteException {
        }

        @Override
        public void registerCallback(ISdkTaskCallback iSdkTaskCallback) throws RemoteException {
        }

        @Override
        public void unregisterCallback(ISdkTaskCallback iSdkTaskCallback) throws RemoteException {
        }

        @Override
        public void getGameBoxUdId() throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

