/*
 * Decompiled with CFR 0.152.
 */
package cn.m4399.operate.support.websocket.framing;

import android.support.annotation.NonNull;
import cn.m4399.operate.support.websocket.enums.Opcode;
import cn.m4399.operate.support.websocket.exceptions.InvalidDataException;
import cn.m4399.operate.support.websocket.framing.BinaryFrame;
import cn.m4399.operate.support.websocket.framing.CloseFrame;
import cn.m4399.operate.support.websocket.framing.ContinuousFrame;
import cn.m4399.operate.support.websocket.framing.Framedata;
import cn.m4399.operate.support.websocket.framing.PingFrame;
import cn.m4399.operate.support.websocket.framing.PongFrame;
import cn.m4399.operate.support.websocket.framing.TextFrame;
import cn.m4399.operate.support.websocket.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.Objects;

public abstract class FramedataImpl1
implements Framedata {
    private boolean a;
    private final Opcode b;
    private ByteBuffer c;
    private boolean d;
    private boolean e;
    private boolean f;
    private boolean g;

    public FramedataImpl1(Opcode opcode) {
        FramedataImpl1 framedataImpl1 = this;
        framedataImpl1.b = opcode;
        framedataImpl1.c = ByteBufferUtils.getEmptyByteBuffer();
        framedataImpl1.a = true;
        framedataImpl1.d = false;
        framedataImpl1.e = false;
        framedataImpl1.f = false;
        framedataImpl1.g = false;
    }

    public static FramedataImpl1 get(Opcode opcode) {
        if (opcode != null) {
            switch (cn.m4399.operate.support.websocket.framing.FramedataImpl1$a.a[opcode.ordinal()]) {
                default: {
                    throw new IllegalArgumentException("Supplied opcode is invalid");
                }
                case 6: {
                    return new ContinuousFrame();
                }
                case 5: {
                    return new CloseFrame();
                }
                case 4: {
                    return new BinaryFrame();
                }
                case 3: {
                    return new TextFrame();
                }
                case 2: {
                    return new PongFrame();
                }
                case 1: 
            }
            return new PingFrame();
        }
        throw new IllegalArgumentException("Supplied opcode cannot be null");
    }

    public abstract void isValid() throws InvalidDataException;

    @Override
    public boolean isRSV1() {
        return this.e;
    }

    @Override
    public boolean isRSV2() {
        return this.f;
    }

    @Override
    public boolean isRSV3() {
        return this.g;
    }

    @Override
    public boolean isFin() {
        return this.a;
    }

    @Override
    public Opcode getOpcode() {
        return this.b;
    }

    @Override
    public boolean getTransfereMasked() {
        return this.d;
    }

    @Override
    public ByteBuffer getPayloadData() {
        return this.c;
    }

    @Override
    public void append(Framedata framedata) {
        ByteBuffer byteBuffer = framedata.getPayloadData();
        if (this.c == null) {
            this.c = ByteBuffer.allocate(byteBuffer.remaining());
            byteBuffer.mark();
            this.c.put(byteBuffer);
            byteBuffer.reset();
        } else {
            FramedataImpl1 framedataImpl1 = this;
            byteBuffer.mark();
            ByteBuffer byteBuffer2 = framedataImpl1.c;
            byteBuffer2.position(byteBuffer2.limit());
            ByteBuffer byteBuffer3 = framedataImpl1.c;
            byteBuffer3.limit(byteBuffer3.capacity());
            if (byteBuffer.remaining() > this.c.remaining()) {
                ByteBuffer byteBuffer4 = ByteBuffer.allocate(byteBuffer.remaining() + this.c.capacity());
                FramedataImpl1 framedataImpl12 = this;
                framedataImpl12.c.flip();
                byteBuffer4.put(framedataImpl12.c);
                byteBuffer4.put(byteBuffer);
                this.c = byteBuffer4;
            } else {
                this.c.put(byteBuffer);
            }
            this.c.rewind();
            byteBuffer.reset();
        }
        this.a = framedata.isFin();
    }

    @NonNull
    public String toString() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder().append("Framedata{ opcode:").append((Object)((FramedataImpl1)object).getOpcode()).append(", fin:").append(((FramedataImpl1)object).isFin()).append(", rsv1:").append(((FramedataImpl1)object).isRSV1()).append(", rsv2:").append(((FramedataImpl1)object).isRSV2()).append(", rsv3:").append(((FramedataImpl1)object).isRSV3()).append(", payload length:[pos:").append(((FramedataImpl1)object).c.position()).append(", len:").append(((FramedataImpl1)object).c.remaining()).append("], payload:");
        if (((FramedataImpl1)object).c.remaining() > 1000) {
            object = "(too big to display)";
        } else {
            String string;
            String string2 = string;
            string = new String(((FramedataImpl1)object).c.array());
            object = string2;
        }
        return stringBuilder.append((String)object).append('}').toString();
    }

    public void setPayload(ByteBuffer byteBuffer) {
        this.c = byteBuffer;
    }

    public void setFin(boolean bl) {
        this.a = bl;
    }

    public void setRSV1(boolean bl) {
        this.e = bl;
    }

    public void setRSV2(boolean bl) {
        this.f = bl;
    }

    public void setRSV3(boolean bl) {
        this.g = bl;
    }

    public void setTransferemasked(boolean bl) {
        this.d = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            object = (FramedataImpl1)object;
            if (this.a != ((FramedataImpl1)object).a) {
                return false;
            }
            if (this.d != ((FramedataImpl1)object).d) {
                return false;
            }
            if (this.e != ((FramedataImpl1)object).e) {
                return false;
            }
            if (this.f != ((FramedataImpl1)object).f) {
                return false;
            }
            if (this.g != ((FramedataImpl1)object).g) {
                return false;
            }
            if (this.b != ((FramedataImpl1)object).b) {
                return false;
            }
            return Objects.equals(this.c, ((FramedataImpl1)object).c);
        }
        return false;
    }

    public int hashCode() {
        FramedataImpl1 framedataImpl1 = this;
        int n9 = (framedataImpl1.a * 31 + ((Object)((Object)this.b)).hashCode()) * 31;
        ByteBuffer byteBuffer = framedataImpl1.c;
        int n10 = byteBuffer != null ? byteBuffer.hashCode() : 0;
        return ((((n9 + n10) * 31 + this.d) * 31 + this.e) * 31 + this.f) * 31 + this.g;
    }
}

