/*
 * Decompiled with CFR 0.152.
 */
package cn.m4399.operate.support.websocket;

import cn.m4399.operate.support.websocket.WebSocketImpl;
import cn.m4399.operate.support.websocket.WrappedByteChannel;
import cn.m4399.operate.support.websocket.enums.Role;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;

public class SocketChannelIOHelper {
    private SocketChannelIOHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean read(ByteBuffer byteBuffer, WebSocketImpl webSocketImpl, ByteChannel byteChannel) throws IOException {
        byteBuffer.clear();
        int n9 = byteChannel.read(byteBuffer);
        byteBuffer.flip();
        if (n9 == -1) {
            webSocketImpl.eot();
            return false;
        }
        return n9 != 0;
    }

    public static boolean readMore(ByteBuffer byteBuffer, WebSocketImpl webSocketImpl, WrappedByteChannel wrappedByteChannel) throws IOException {
        ByteBuffer byteBuffer2 = byteBuffer;
        byteBuffer2.clear();
        int n9 = wrappedByteChannel.readMore(byteBuffer2);
        byteBuffer.flip();
        if (n9 == -1) {
            webSocketImpl.eot();
            return false;
        }
        return wrappedByteChannel.isNeedRead();
    }

    public static boolean batch(WebSocketImpl webSocketImpl, ByteChannel byteChannel) throws IOException {
        if (webSocketImpl == null) {
            return false;
        }
        ByteBuffer byteBuffer = (ByteBuffer)webSocketImpl.outQueue.peek();
        WrappedByteChannel wrappedByteChannel = null;
        if (byteBuffer == null) {
            if (byteChannel instanceof WrappedByteChannel && (wrappedByteChannel = (WrappedByteChannel)byteChannel).isNeedWrite()) {
                wrappedByteChannel.writeMore();
            }
        } else {
            WebSocketImpl webSocketImpl2;
            do {
                byteChannel.write(byteBuffer);
                if (byteBuffer.remaining() > 0) {
                    return false;
                }
                webSocketImpl2 = webSocketImpl;
                webSocketImpl2.outQueue.poll();
            } while ((byteBuffer = (ByteBuffer)webSocketImpl2.outQueue.peek()) != null);
        }
        if (webSocketImpl.outQueue.isEmpty() && webSocketImpl.isFlushAndClose() && webSocketImpl.getDraft() != null && webSocketImpl.getDraft().getRole() != null && webSocketImpl.getDraft().getRole() == Role.SERVER) {
            webSocketImpl.closeConnection();
        }
        return wrappedByteChannel == null || !((WrappedByteChannel)byteChannel).isNeedWrite();
    }
}

