package cn.m4399.operate.samples;

import static cn.m4399.operate.samples.GameSettings.COMPACT_NOTCH;
import static cn.m4399.operate.samples.GameSettings.SCREEN_ORIENTATION;

import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.util.Log;
import android.view.View;

import cn.m4399.operate.OpeInitedListener;
import cn.m4399.operate.OperateCenter;
import cn.m4399.operate.OperateConfig;
import cn.m4399.operate.Order;
import cn.m4399.operate.OrderFinished;
import cn.m4399.operate.SingleGame;

public class SingleGameActivity extends FragmentActivity {
    private static final String TAG = "【Demo】";
    private static final String GAME_KEY = "133562";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setRequestedOrientation(SCREEN_ORIENTATION);
        GameSettings.compactNotch(this);

        setContentView(R.layout.single_game_activity);

        // 初始化选项，传入游戏配置，更多说明见接入文档
        OperateConfig opeConfig = new OperateConfig.Builder(this)
                // 设置游戏运营 key，此参数需要在原创开放平台注册应用后得到
                .setGameKey(GAME_KEY)
                // 设置SDK页面方向，应与游戏方向一致，部分第三方页面需要在AndroidManifest中设置
                .setOrientation(SCREEN_ORIENTATION)
                // 设置游戏充值是否支持超出金额，true时支持，默认true
                // 也可以每次充值通过 OperateCenter.setSupportExcess 设置
                .setSupportExcess(true)
                // 设置游戏是否兼在高于Android 9.0版本系统容全面屏，默认不兼容
                .compatNotch(COMPACT_NOTCH)
                .build();

        // 初始化SDK
        SingleGame.init(this, opeConfig, new OpeInitedListener() {
            @Override
            public void onInitFinished() {
                // 完成防沉迷等初始化流程，可进入游戏
            }
        });

        // 单机游戏充值时，允许使用客户端回调，如需使用请联系运营确认
        // 注意 !!!!!：客户端回调不安全，APK 容易被篡改
        // 设置发放物品回调，需要客户端回调才使用
        SingleGame.setDeliveringGoodsListener(new SingleGame.OnDeliveringGoodsListener() {
            @Override
            public boolean onDelivering(OrderFinished of) {
                Log.i(TAG, of.money() + " " + of.conclude().first + " " + of.conclude().second);
                // 如果游戏因为某些原因发放失败，应返回false
                return true;
            }
        });
    }

    public void onRechargeBtnClicked(View view) {
        // 充值
        String mark = GameSettings.createUniqueMark();
        SingleGame.recharge(this,
                // 充值金额，整数，单位元
                // mark: 游戏订单，游戏可以再其中映射用户名、商品信息
                new Order(6, mark)
                        // 是否支持超出金额，默认不支持
                        .supportExcess(false)
                        // 商品名，可选，不传时认为商品名是游戏币，不能包含字符'&'
                        .commodity(getString(R.string.recharge_commodity_name)),
                new OperateCenter.OnRechargeFinishedListener() {
                    @Override
                    public void onRechargeFinished(boolean success, int resultCode, String msg) {
                        Log.i(TAG, resultCode + " " + msg);
                    }
                });
    }

    public void onUpgradeBtnClicked(View view) {
        // 自定义更新
        new UpgradeController().doUpgrade(this, view);
    }
}
