package cn.m4399.operate.samples;

import android.app.Activity;
import android.content.pm.ActivityInfo;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;

/*
 * Created by <zhangsheng@4399inc.com> on 2021-09-16.
 */
class GameSettings {
    private final static int MARK_MAX_LENGTH = 32;
    private final static String MARK_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";

    static final int SCREEN_ORIENTATION = ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE;
    static final boolean SUPPORT_EXCESS = true;
    static final boolean COMPACT_NOTCH = true;

    public static void compactNotch(Activity activity) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P && COMPACT_NOTCH) {
            Window window = activity.getWindow();
            if (window != null) {
                WindowManager.LayoutParams lp = window.getAttributes();
                lp.layoutInDisplayCutoutMode = WindowManager.LayoutParams.LAYOUT_IN_DISPLAY_CUTOUT_MODE_SHORT_EDGES;
                window.setAttributes(lp);
                // 允许内容绘制到耳朵区
                final View decorView = window.getDecorView();
                decorView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);
            }
        }
    }

    private static String b62(long num) {
        StringBuilder sb = new StringBuilder();
        int remainder;
        while (num > 21) {
            //对 scale 进行求余，然后将余数追加至 sb 中，由于是从末位开始追加的，因此最后需要反转字符串
            remainder = Long.valueOf(num % 62).intValue();
            sb.append(MARK_CHARS.charAt(remainder));
            //除以进制数，获取下一个末尾数
            num = num / 62;
        }
        sb.append(MARK_CHARS.charAt(Long.valueOf(num).intValue()));
        return sb.reverse().toString();
    }

    public static String createUniqueMark() {
        // 生成mark示例, 支持字母、数字和字符‘-’，‘_’，‘|’，最长32位
        // 参考格式：商品id|用户id-区服id_时间戳
        String mark = "cid|uid-sid_" + b62(System.currentTimeMillis());
        if (mark.length() > MARK_MAX_LENGTH)
            mark = mark.substring(0, MARK_MAX_LENGTH);
        return mark;
    }
}
