package cn.m4399.login.union.demo;


import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import android.widget.Toast;

import java.util.List;

import cn.m4399.login.union.api.AccountCandidate;
import cn.m4399.login.union.api.AccountNegotiation;
import cn.m4399.login.union.api.Code;
import cn.m4399.login.union.api.LoginNonPassword;
import cn.m4399.login.union.api.LoginUiModel;
import cn.m4399.login.union.api.OnLoginFinishedListener;
import cn.m4399.login.union.api.OnResultListener;
import cn.m4399.login.union.api.PrivacySpannableHolder;
import cn.m4399.login.union.api.User;

public class MainActivity extends AppCompatActivity implements OnLoginFinishedListener,
        AccountNegotiation {
    private static final String TAG = "4399Login";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
    }

    public void onBtnLoginClicked(final View view) {
        view.setEnabled(false);
        // 检查设备当前状态是否支持一键登录
        LoginNonPassword.canSupport(new OnResultListener() {
            @Override
            public void onResult(long code, String message) {
                Log.i("4399Login", "Check LoginNonPassword supported: " + LoginNonPassword.getPreLoginStatus());
                if (code != Code.OK) {
                    Toast.makeText(MainActivity.this, message, Toast.LENGTH_SHORT).show();
                    view.setEnabled(true);
                    return;
                }

                LoginUiModel uiModel = new LoginUiModel()
                        // 可选，设置登录Activity上显示的app logo
                        .appLogo(R.mipmap.ic_launcher_round)
                        // 可选，设置登录Activity上显示的app 名称
                        .appName(R.string.demo_app_name)
                        // 可选，设置打开登录Activity时的切换动画
                        .startActivityAnimation(R.anim.demo_slide_in_right, R.anim.demo_slide_out_left)
                        // 可选，设置关闭登录Activity时的切换动画
                        .finishActivityAnimation(R.anim.demo_slide_in_left, R.anim.demo_slide_out_right)
                        // 可选，设置登录Activity布局id
                        .loginActivityLayout(R.layout.demo_activity_ct_account_auth)
                        // 可选，设置隐私协议是否默认勾选，默认不勾选，SDK 不记忆此状态
                        .privacyChecked(false)
                        // 可选，设置额外的隐私链接，及其他富文本，至少应有运营商隐私协议
                        .privacySpans(new PrivacySpannableHolder(
                                R.string.demo_account_privacy_formatter,
                                new PrivacySpannableHolder.OperatorPrivacy(R.color.demo_color_d81b60),
                                new PrivacySpannableHolder.Privacy(R.string.demo_account_privacy_name_1,
                                        R.color.demo_color_d81b60,
                                        R.string.demo_account_privacy_url_1),
                                new PrivacySpannableHolder.Privacy(R.string.demo_account_privacy_name_2,
                                        R.color.demo_color_d81b60,
                                        R.string.demo_account_privacy_url_2),
                                new PrivacySpannableHolder.Content(R.string.demo_app_name, R.color.demo_color_primary)
                        ))
                        // 可选，设置“用户隐私政策”确认对话框布局id
                        .privacyConfirmDialogLayout(R.layout.demo_dialog_ct_account_privacy)
                        // 可选，设置”用户隐私政策“内容Activity布局
                        .privacyContentActivityLayout(R.layout.demo_activity_ct_account_privacy)
                        // 可选，若自定义了登录Activity布局，同时在布局中添加了元素，可以通过此方式添加点击回调
                        .extendView(
                                new LoginUiModel.ExtendViewHolder(R.id.tv_sms_login, newOnClickListener()),
                                new LoginUiModel.ExtendViewHolder(R.id.tv_password_login, newOnClickListener())
                        );

                // 登录，使用自定义UI，假设MainActivity实现了OnLoginFinishedListener接口
                LoginNonPassword.login(MainActivity.this, MainActivity.this,
                        MainActivity.this, uiModel);
                // 登录，使用默认UI，
                //LoginNonPassword.login(MainActivity.this, MainActivity.this);
            }
        });
    }

    private View.OnClickListener newOnClickListener() {
        return new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                TextView tv = (TextView) v;
                logAndToast(String.valueOf(tv.getText()));
                Context context = v.getContext();
                if (context instanceof Activity) {
                    Activity activity = (Activity) context;
                    if (!activity.isFinishing()) {
                        activity.finish();
                        findViewById(R.id.demo_id_btn_login).setEnabled(true);
                    }
                }
            }
        };
    }

    // 处理登录结果
    // 正常登录后得到User对象，包含uid、accessToken、refreshToken
    // 若失败，返回的code、message可以在接入文档附录部分确认
    @Override
    public void onLoginFinished(long code, String message, User user) {
        if (code == Code.SUCCESS) {
            logAndToast(getString(R.string.demo_fmt_login_success, user.uid()));
        } else {
            logAndToast(getString(R.string.demo_fmt_login_error, code, message));
        }
        findViewById(R.id.demo_id_btn_login).setEnabled(true);
    }

    @Override
    public void onMultiAccount(String desensitizedPhone, List<AccountCandidate> candidates) {
        // 接入方应展示候选列表，供用户选择
        int selected = (int) (System.currentTimeMillis() % candidates.size()); // 随机选择一个登录，
        candidates.get(selected).onSelected();
    }

    private void logAndToast(String message) {
        Toast.makeText(getApplicationContext(), message, Toast.LENGTH_SHORT).show();
        Log.d(TAG, message);
    }
}
