package cn.m4399.login.union.demo;

import android.app.Application;

import cn.m4399.login.union.api.Client;
import cn.m4399.login.union.api.LoginNonPassword;
import cn.m4399.login.union.api.OnResultListener;
import cn.m4399.login.union.api.Options;

/**
 * Created by <zhangsheng@4399inc.com> on 2019-09-11.
 */
public class DemoApplication extends Application {
    private static final String DEMO_CLIENT_ID = "002ba29f6761b942f1776cbf578a7a58";

    @Override
    public void onCreate() {
        super.onCreate();

        // 尽早初始化SDK，建议在Application类的onCreate里面
        LoginNonPassword.init(
                new Options()
                        .debuggable(false) // 可选，是否开启调试模式，开启true，否则false，默认不开启
                        .appContext(getApplicationContext()),
                new Client()

                        .withId(DEMO_CLIENT_ID), // 必须，应用中4399平台的client id
                new OnResultListener() {
                    @Override
                    public void onResult(long code, String message) {
                        // SDK 初始化结束，若初始化失败将会在登录前再初始化一次
                    }
                }
        );
    }
}
